import com.exalate.basic.domain.BasicIssueKey
/**
Replace your "Incoming sync for existing issues (change processor)" with this snippet:


return ChangeProcessor.execute(
    replica,
    issue,
    nodeHelper,
    commentHelper,
    attachmentHelper,
    workLogHelper,
    userHelper,
    workflowHelper,
    previous,
    connection,
    issueKey,
    previousReplica,
    currentReplica,
    traces,
    blobMetadataList,
    issueBeforeScript
)


 * */
class ChangeProcessor {
    static execute(
            com.exalate.basic.domain.hubobject.v1.BasicHubIssue replica,
            com.exalate.basic.domain.hubobject.v1.BasicHubIssue issue,
            com.exalate.basic.domain.hubobject.v1.BasicHubIssue previous,
            com.exalate.basic.domain.hubobject.v1.BasicHubIssue issueBeforeScript,
            com.exalate.basic.domain.BasicIssueKey issueKey,
            com.exalate.api.domain.connection.IConnection connection,
            List<com.exalate.api.domain.twintrace.INonPersistentTrace> traces,
            scala.collection.Seq<com.exalate.api.domain.IBlobMetadata> blobMetadataList,
            services.jcloud.hubobjects.NodeHelper nodeHelper,
            com.exalate.hubobject.jira.CommentHelper commentHelper,
            com.exalate.hubobject.jira.AttachmentHelper attachmentHelper,
            com.exalate.hubobject.jira.WorkLogHelper workLogHelper,
            com.exalate.hubobject.jira.WorkflowHelper workflowHelper,
            services.jcloud.hubobjects.ServiceDeskHelper serviceDeskHelper,
            log, //ch.qos.logback.classic.Logger log
            services.replication.PreparedHttpClient httpClient,
            com.exalate.api.domain.request.ISyncRequest syncRequest) {

        // YOUR "Incoming sync for existing issues (change processor)":
        issue.summary      = replica.summary
        issue.description  = replica.description
        issue.assignee     = nodeHelper.getUserByUsername(replica.assignee?.username)
        issue.reporter     = nodeHelper.getUserByUsername(replica.reporter?.username)
        issue.labels       = replica.labels
        issue.comments     = commentHelper.mergeComments(issue, replica)
        issue.attachments  = attachmentHelper.mergeAttachments(issue, replica)
        // END: YOUR "Incoming sync for existing issues (change processor)"

        return null
    }
}