import com.exalate.basic.domain.BasicIssueKey
/**
Replace your "Incoming sync for existing issues (change processor)" with this snippet:


return ChangeProcessor.execute(
    replica,
    issue,
    nodeHelper,
    commentHelper,
    attachmentHelper,
    workLogHelper,
    userHelper,
    workflowHelper,
    previous,
    connection,
    issueKey,
    previousReplica,
    currentReplica,
    traces,
    blobMetadataList,
    issueBeforeScript
)


 * */
class ChangeProcessor {
    static BasicIssueKey execute(
            //entities
            com.exalate.basic.domain.hubobject.v1.BasicHubIssue replica,
            com.exalate.basic.domain.hubobject.v1.BasicHubIssue issue,
            //helpers
            com.exalate.node.hubobject.v1_3.NodeHelper nodeHelper,
            com.exalate.node.hubobject.v1_2.CommentHelper commentHelper,
            com.exalate.node.hubobject.v1_5.AttachmentHelper attachmentHelper,
            com.exalate.hubobject.jira.WorkLogHelper workLogHelper,
            com.exalate.node.hubobject.v1_5.UserHelper userHelper,
            com.exalate.node.hubobject.v1_5.WorkflowHelper workflowHelper,
            //context
            com.exalate.basic.domain.hubobject.v1.BasicHubIssue previous,
            com.exalate.api.domain.connection.IConnection connection,
            com.exalate.basic.domain.BasicIssueKey issueKey,
            com.exalate.api.domain.INonPersistentReplica previousReplica,
            com.exalate.api.domain.INonPersistentReplica currentReplica,
            List<com.exalate.api.domain.twintrace.INonPersistentTrace> traces,
            List<com.exalate.api.domain.IBlobMetadata> blobMetadataList,
            com.exalate.basic.domain.hubobject.v1.BasicHubIssue issueBeforeScript) {

        // YOUR "Incoming sync for existing issues (change processor)":
        issue.summary      = replica.summary
        issue.description  = replica.description
        issue.assignee     = nodeHelper.getUserByUsername(replica.assignee?.username)
        issue.reporter     = nodeHelper.getUserByUsername(replica.reporter?.username)
        issue.labels       = replica.labels
        issue.comments     = commentHelper.mergeComments(issue, replica)
        issue.attachments  = attachmentHelper.mergeAttachments(issue, replica)
        // END: YOUR "Incoming sync for existing issues (change processor)"

        return null
    }
}