import com.exalate.basic.domain.BasicIssueKey
/**
Replace your "Incoming sync for new issues (create processor)" with this snippet:


return CreateProcessor.execute(
    replica,
    issue,
    nodeHelper,
    commentHelper,
    attachmentHelper,
    workLogHelper,
    userHelper,
    workflowHelper,
    connection,
    remoteReplica,
    traces,
    blobMetadataList,
    issueBeforeScript
)


 * */
class CreateProcessor {
    static BasicIssueKey execute(
            //entities
            com.exalate.basic.domain.hubobject.v1.BasicHubIssue replica,
            com.exalate.basic.domain.hubobject.v1.BasicHubIssue issue,
            //helpers
            com.exalate.node.hubobject.v1_3.NodeHelper nodeHelper,
            com.exalate.node.hubobject.v1_2.CommentHelper commentHelper,
            com.exalate.node.hubobject.v1_5.AttachmentHelper attachmentHelper,
            com.exalate.hubobject.jira.WorkLogHelper workLogHelper,
            com.exalate.node.hubobject.v1_5.UserHelper userHelper,
            com.exalate.node.hubobject.v1_5.WorkflowHelper workflowHelper,
            //context
            com.exalate.api.domain.connection.IConnection connection,
            com.exalate.api.domain.INonPersistentReplica remoteReplica,
            List<com.exalate.api.domain.twintrace.INonPersistentTrace> traces,
            List<com.exalate.api.domain.IBlobMetadata> blobMetadataList,
            com.exalate.basic.domain.hubobject.v1.BasicHubIssue issueBeforeScript) {

        // YOUR "Incoming sync for new issues (create processor)":
        issue.projectKey   = "TEST"
        issue.typeName     = nodeHelper.getIssueType(replica.type?.name, issue.projectKey)?.name ?: "Task"
        issue.summary      = replica.summary
        issue.description  = replica.description
        issue.assignee     = nodeHelper.getUserByUsername(replica.assignee?.username)
        issue.reporter     = nodeHelper.getUserByUsername(replica.reporter?.username)
        issue.labels       = replica.labels
        issue.comments     = commentHelper.mergeComments(issue, replica)
        issue.attachments  = attachmentHelper.mergeAttachments(issue, replica)
        // END: YOUR "Incoming sync for new issues (create processor)"

        return null
    }
}